/*! \file    
**********************************************************************************	
* Title:						Discretix SST API Source file						 					
*																			
* Filename:						sst_api_data_iterators.c															
*																			
* Project, Target, subsystem:	SST Host IF, APIs	
* 
* Created:						01.07.2007															
*
* Modified:																
*
* \Author						Ira Boguslavsky														
*																			
* \Remarks						
*           Copyright (C) 2006 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/

/*----------- External include files ----------------------------------------*/
#include "DX_VOS_Mem.h"
#include "SEPDriver.h"
#include "error.h"
#include "sst_errors.h"
#include "sst_sep_errors.h"
#include "sst_types.h"
#include "sst_host_util.h"
#include "sst_host_def.h"
/*----------- Local include files -------------------------------------------*/
#include "sst_test_flags.h"
#include "sst_host_op_code.h"

/*----------- Local include files -------------------------------------------*/
/*----------- Local Variable declarations -----------------------------------*/
/*----------- Local function declarations -----------------------------------*/
/*----------- Local constant definitions  -----------------------------------*/

/*---------------------------------------------------------------------------*/
/*               API FUNCTIONS                                               */
/*---------------------------------------------------------------------------*/

 /************************************************************************/
/*                    Indexing		                                    */
/************************************************************************/
/*SST_IndexLookupDelete*/
/*SST_IndexLookupDelete*/
DxError_t SST_IndexLookupDelete (SSTTxnId_t      aTransactionId,
                                 SSTSessionId_t  aSessionId,
                                 DxUint32_t      aStringSizeInBytes,
                                 DxByte_t       *aString_ptr,
                                 DxByte_t       *aWorkspace_ptr,
                                 DxUint32_t      aWorkspaceSizeInBytes)
{
    DxUint32_t              paramInBuffer_ptr [DX_5_WORDS_PARAMS];
    DxUint32_t              paramOutBuffer_ptr[DX_2_WORDS_PARAMS];
    DxError_t               errorRC;
    DxUint32_t				stringSMPhy;
    DxUint32_t				stringSMVirt;

    /* Eliminating warnings regarding useless variables */
    aWorkspace_ptr = aWorkspace_ptr;
    aWorkspaceSizeInBytes = aWorkspaceSizeInBytes;

    if(DX_IS_NULL_PARAM(aString_ptr))
        return SST_RC_ERROR_NULL_POINTER;

	/************************************************************************/
	/*  Lock access to SEP                                                  */
	/************************************************************************/
   errorRC = SEPDriver_Lock();
   if(DX_MNG_SEP_IS_DISABLE_ERR == errorRC)
   {
       errorRC = SST_RC_ERROR_SEP_DISABLED; 
       goto exit_function;
   }
   else if (DX_OK != errorRC)
   {
       errorRC = SST_RC_ERROR_SEP; 
       goto exit_function;
   }
	/************************************************************************/
    /* Prepare input buffer                                                 */
    /************************************************************************/
	/*allocate memory in SM*/
	errorRC = SEPDriver_AllocateDataPoolMemory( aString_ptr, 
                                                aStringSizeInBytes, 
                                                &stringSMPhy,
                                                &stringSMVirt);
	SST_HOST_DRIVER_ERROR_CHECK(errorRC,exit_ixlu_delete) ;
	/*copy to the SM*/	
	errorRC = SEPDriver_WriteToDataPoolMemory(stringSMVirt, aString_ptr, aStringSizeInBytes);
	SST_HOST_DRIVER_ERROR_CHECK(errorRC,exit_ixlu_delete) ;
	
	/* Operation Code */
    paramInBuffer_ptr[0] = SST_SEP_OP_CODE_INDEX_LOOK_UP_DELETE;

    /*  Input Parameters */
    paramInBuffer_ptr[1] = (DxUint32_t)aTransactionId;
    paramInBuffer_ptr[2] = (DxUint32_t)aSessionId;
    paramInBuffer_ptr[3] = (DxUint32_t)aStringSizeInBytes;
    paramInBuffer_ptr[4] = (DxUint32_t)stringSMPhy;

    /************************************************************************/
    /* Send an input buffer to SeP and wait for output parameters          */
    /************************************************************************/
    errorRC = SST_SendOneMsgGetResponse(paramInBuffer_ptr,
        /* Input buffer length */
        DX_5_WORDS_PARAMS * sizeof(DxUint32_t), 
        paramOutBuffer_ptr,
        /* Output buffer maximal length */
        DX_2_WORDS_PARAMS * sizeof(DxUint32_t));  
    if (DX_OK != errorRC)
        goto exit_ixlu_delete;

    /************************************************************************/
    /* Analyze return buffer                                                */
    /************************************************************************/
    /* Op code */
    if (paramOutBuffer_ptr[0] != SST_SEP_OP_CODE_INDEX_LOOK_UP_DELETE)
    {
        errorRC = SST_RC_ERROR_SEP;
        goto exit_ixlu_delete;
    }

    /* RC */    
	errorRC = paramOutBuffer_ptr[1];
	SST_HOST_RETURN_CODE_CHECK(errorRC,exit_ixlu_delete);

exit_ixlu_delete: 	
	/************************************************************************/
	/* UnLock access to  SEP                                                  */
	/************************************************************************/
	SEPDriver_Unlock();

exit_function:
    
    return errorRC;
}    

/*SST_IndexLookupBind*/
DxError_t SST_IndexLookupBind( SSTTxnId_t      aTransactionId,
                              SSTSessionId_t  aSessionId,
                              SSTHandle_t     aHandle,
                              DxUint32_t      aStringSizeInBytes,
                              DxByte_t       *aString_ptr,
                              DxByte_t       *aWorkspace_ptr,
                              DxUint32_t      aWorkspaceSizeInBytes)
{
    DxUint32_t              paramInBuffer_ptr [DX_7_WORDS_PARAMS];
    DxUint32_t              paramOutBuffer_ptr[DX_2_WORDS_PARAMS];
    DxError_t               errorRC;
    DxUint32_t				stringSMPhy;
    DxUint32_t				stringSMVirt;

    /* Eliminating warnings regarding useless variables */
    aWorkspace_ptr = aWorkspace_ptr;
    aWorkspaceSizeInBytes = aWorkspaceSizeInBytes;
    
    if(DX_IS_NULL_PARAM(aString_ptr))
        return SST_RC_ERROR_NULL_POINTER;

	/************************************************************************/
	/*  Lock access to SEP                                                  */
	/************************************************************************/
   errorRC = SEPDriver_Lock();
   if(DX_MNG_SEP_IS_DISABLE_ERR == errorRC)
   {
       errorRC = SST_RC_ERROR_SEP_DISABLED; 
       goto exit_function;
   }
   else if (DX_OK != errorRC)
   {
       errorRC = SST_RC_ERROR_SEP; 
       goto exit_function;
   }
	/************************************************************************/
    /* Prepare input buffer                                                 */
    /************************************************************************/
	/*allocate memory in SM*/
	errorRC = SEPDriver_AllocateDataPoolMemory( aString_ptr, 
                                                aStringSizeInBytes, 
                                                &stringSMPhy,
                                                &stringSMVirt);
	SST_HOST_DRIVER_ERROR_CHECK(errorRC,exit_ixlu_bind) ;
	/*copy to the SM*/
	errorRC = SEPDriver_WriteToDataPoolMemory(stringSMVirt,aString_ptr, aStringSizeInBytes);
	SST_HOST_DRIVER_ERROR_CHECK(errorRC,exit_ixlu_bind) ;
	
	/* Operation Code */
    paramInBuffer_ptr[0] = SST_SEP_OP_CODE_INDEX_LOOK_UP_BIND;

    /*  Input Parameters */
    paramInBuffer_ptr[1] = (DxUint32_t)aTransactionId;
    paramInBuffer_ptr[2] = (DxUint32_t)aSessionId;
    paramInBuffer_ptr[3] = (DxUint32_t)aHandle.objDigest;
    paramInBuffer_ptr[4] = (DxUint32_t)aHandle.objId;
    paramInBuffer_ptr[5] = (DxUint32_t)aStringSizeInBytes;
    paramInBuffer_ptr[6] = (DxUint32_t)stringSMPhy;

    /************************************************************************/
    /* Send an input buffer to SeP and wait for output parameters          */
    /************************************************************************/
    errorRC = SST_SendOneMsgGetResponse(paramInBuffer_ptr,
        /* Input buffer length */
        DX_7_WORDS_PARAMS * sizeof(DxUint32_t), 
        paramOutBuffer_ptr,
        /* Output buffer length */
        DX_2_WORDS_PARAMS * sizeof(DxUint32_t));  
    if (DX_OK != errorRC)
        goto exit_ixlu_bind;

    /************************************************************************/
    /* Analyze return buffer                                                */
    /************************************************************************/
    /* Op code */
    if (paramOutBuffer_ptr[0] != SST_SEP_OP_CODE_INDEX_LOOK_UP_BIND)
    {
        errorRC = SST_RC_ERROR_SEP;
        goto exit_ixlu_bind;
    }

    /* RC */    
	errorRC = paramOutBuffer_ptr[1];
	SST_HOST_RETURN_CODE_CHECK(errorRC,exit_ixlu_bind);

exit_ixlu_bind: 
	/************************************************************************/
	/* UnLock access to  SEP                                                  */
	/************************************************************************/
	SEPDriver_Unlock();

exit_function:
    
    return errorRC;
}

/*SST_IndexLookupUnbind*/
DxError_t SST_IndexLookupUnbind( SSTTxnId_t      aTransactionId,
                                SSTSessionId_t  aSessionId,
                                SSTHandle_t     aHandle,
                                DxUint32_t      aStringSizeInBytes,
                                DxByte_t       *aString_ptr,
                                DxByte_t       *aWorkspace_ptr,
                                DxUint32_t      aWorkspaceSizeInBytes)
{
    DxUint32_t              paramInBuffer_ptr [DX_7_WORDS_PARAMS];
    DxUint32_t              paramOutBuffer_ptr[DX_2_WORDS_PARAMS];
    DxError_t               errorRC;
    DxUint32_t				stringSMPhy;
    DxUint32_t				stringSMVirt;

    /* Eliminating warnings regarding useless variables */
    aWorkspace_ptr = aWorkspace_ptr;
    aWorkspaceSizeInBytes = aWorkspaceSizeInBytes;
    
    if(DX_IS_NULL_PARAM(aString_ptr))
        return SST_RC_ERROR_NULL_POINTER;

	/************************************************************************/
	/*  Lock access to SEP                                                  */
	/************************************************************************/
   errorRC = SEPDriver_Lock();
   if(DX_MNG_SEP_IS_DISABLE_ERR == errorRC)
   {
       errorRC = SST_RC_ERROR_SEP_DISABLED; 
       goto exit_function;
   }
   else if (DX_OK != errorRC)
   {
       errorRC = SST_RC_ERROR_SEP; 
       goto exit_function;
   }
	/************************************************************************/
    /* Prepare input buffer                                                 */
    /************************************************************************/
	/*allocate memory in SM*/
	errorRC = SEPDriver_AllocateDataPoolMemory( aString_ptr, 
                                                aStringSizeInBytes, 
                                                &stringSMPhy,
                                                &stringSMVirt);
	SST_HOST_DRIVER_ERROR_CHECK(errorRC,exit_ixlu_unbind) ;
	/*copy to the SM*/
	errorRC = SEPDriver_WriteToDataPoolMemory(stringSMVirt,aString_ptr, aStringSizeInBytes);
	SST_HOST_DRIVER_ERROR_CHECK(errorRC,exit_ixlu_unbind) ;
	
	/* Operation Code */
    paramInBuffer_ptr[0] = SST_SEP_OP_CODE_INDEX_LOOK_UP_UNBIND;

    /*  Input Parameters */
    paramInBuffer_ptr[1] = (DxUint32_t)aTransactionId;
    paramInBuffer_ptr[2] = (DxUint32_t)aSessionId;
    paramInBuffer_ptr[3] = (DxUint32_t)aHandle.objDigest;
    paramInBuffer_ptr[4] = (DxUint32_t)aHandle.objId;
    paramInBuffer_ptr[5] = (DxUint32_t)aStringSizeInBytes;
    paramInBuffer_ptr[6] = (DxUint32_t)stringSMPhy;

    /************************************************************************/
    /* Send an input buffer to SeP and wait for output parameters          */
    /************************************************************************/
    errorRC = SST_SendOneMsgGetResponse(paramInBuffer_ptr,
        /* Input buffer length */
        DX_7_WORDS_PARAMS * sizeof(DxUint32_t), 
        paramOutBuffer_ptr,
        /* Output buffer maximal length */
        DX_2_WORDS_PARAMS * sizeof(DxUint32_t));  
    if (DX_OK != errorRC)
        goto exit_ixlu_unbind;

    /************************************************************************/
    /* Analyze return buffer                                                */
    /************************************************************************/
    /* Op code */
    if (paramOutBuffer_ptr[0] != SST_SEP_OP_CODE_INDEX_LOOK_UP_UNBIND)
    {
        errorRC = SST_RC_ERROR_SEP;
        goto exit_ixlu_unbind;
    }

    /* RC */    
	errorRC = paramOutBuffer_ptr[1];
	SST_HOST_RETURN_CODE_CHECK(errorRC,exit_ixlu_unbind);

exit_ixlu_unbind: 
	/************************************************************************/
	/* UnLock access to  SEP                                                  */
	/************************************************************************/
	SEPDriver_Unlock();

 exit_function:
    
    return errorRC;
}

/* SST_IndexLookUpBegin */
DxError_t SST_IndexLookUpBegin (DxByte_t       *aString_ptr,
                                DxUint32_t      aStringLengthInBytes,
                                SSTIXCookie_t  *aIterCookie_ptr)
{
    DxUint32_t              paramInBuffer_ptr [DX_3_WORDS_PARAMS];
    DxUint32_t              paramOutBuffer_ptr[DX_8_WORDS_PARAMS];
    DxError_t               errorRC;
    DxUint32_t				stringSMPhy;
    DxUint32_t				stringSMVirt;

    if(DX_IS_NULL_2PARAMS(aString_ptr,aIterCookie_ptr))
        return SST_RC_ERROR_NULL_POINTER;

	/************************************************************************/
	/*  Lock access to SEP                                                  */
	/************************************************************************/
   errorRC = SEPDriver_Lock();
   if(DX_MNG_SEP_IS_DISABLE_ERR == errorRC)
   {
       errorRC = SST_RC_ERROR_SEP_DISABLED; 
       goto exit_function;
   }
   else if (DX_OK != errorRC)
   {
       errorRC = SST_RC_ERROR_SEP; 
       goto exit_function;
   }
	/************************************************************************/
    /* Prepare input buffer                                                 */
    /************************************************************************/
	/*allocate memory in SM*/
	errorRC = SEPDriver_AllocateDataPoolMemory( aString_ptr, 
                                                aStringLengthInBytes, 
                                                &stringSMPhy,
                                                &stringSMVirt);
	SST_HOST_DRIVER_ERROR_CHECK(errorRC,exit_ixlu_begin) ;
	/*copy to the SM*/
	errorRC = SEPDriver_WriteToDataPoolMemory(stringSMVirt,aString_ptr, aStringLengthInBytes);
	SST_HOST_DRIVER_ERROR_CHECK(errorRC,exit_ixlu_begin) ;
	
	/* Operation Code */
    paramInBuffer_ptr[0] = SST_SEP_OP_CODE_INDEX_LOOK_UP_BEGIN;

    /* Input Parameters */
    paramInBuffer_ptr[1] = (DxUint32_t)stringSMPhy;
    paramInBuffer_ptr[2] = (DxUint32_t)aStringLengthInBytes;

    /************************************************************************/
    /* Send an input buffer to SeP and wait for output parameters          */
    /************************************************************************/
    errorRC = SST_SendOneMsgGetResponse(paramInBuffer_ptr,
        /* Input buffer length */
        DX_3_WORDS_PARAMS * sizeof(DxUint32_t), 
        paramOutBuffer_ptr,
        /* Output buffer maximal length */
        DX_8_WORDS_PARAMS * sizeof(DxUint32_t));  
    if (DX_OK != errorRC)
        goto exit_ixlu_begin;

    /************************************************************************/
    /* Analyze return buffer                                                */
    /************************************************************************/
    /* Op code */
    if (paramOutBuffer_ptr[0] != SST_SEP_OP_CODE_INDEX_LOOK_UP_BEGIN)
    {
        errorRC = SST_RC_ERROR_SEP;
        goto exit_ixlu_begin;
    }

    /* RC */    
	errorRC = paramOutBuffer_ptr[1];
	SST_HOST_RETURN_CODE_CHECK(errorRC,exit_ixlu_begin);

    /* Fill out output parameters */ 
    aIterCookie_ptr->cookieHandle.prefixMsb         = paramOutBuffer_ptr[2];
    aIterCookie_ptr->cookieHandle.prefixLsb         = paramOutBuffer_ptr[3];
    aIterCookie_ptr->cookieHandle.prefixSize        = paramOutBuffer_ptr[4];
    aIterCookie_ptr->cookieHandle.lastPositionMsb   = paramOutBuffer_ptr[5];
    aIterCookie_ptr->cookieHandle.lastPositionLsb   = paramOutBuffer_ptr[6];
    aIterCookie_ptr->cookieHandle.initialUse        = (DxBool_t)paramOutBuffer_ptr[7];

exit_ixlu_begin: 
	/************************************************************************/
	/* UnLock access to  SEP                                                  */
	/************************************************************************/
	SEPDriver_Unlock();

exit_function:
    
    return errorRC;
}

/*SST_IndexLookUpHandlesGet*/
DxError_t SST_IndexLookUpHandlesGet(SSTSessionId_t       aSessionId,
									SSTIXCookie_t       *aIterCookie_ptr,
									SSTHandle_t         *aHandlesBuff,
									DxUint32_t          *aNumberOfHandlesToRead_ptr,
									DxUint32_t          *aHandlesLeft_ptr,
									DxByte_t            *aWorkspace_ptr,
									DxUint32_t           aWorkspaceSizeInBytes)
{
    DxUint32_t              paramInBuffer_ptr [DX_11_WORDS_PARAMS];
    DxUint32_t              paramOutBuffer_ptr[DX_10_WORDS_PARAMS];
    DxError_t               errorRC;
    DxError_t               sepErrorRC;
    DxUint32_t				handleBuffSMPhyAddress;
    DxUint32_t				handleBuffSMVirtAddress;

    /* Eliminating warnings regarding useless variables */
    aWorkspace_ptr = aWorkspace_ptr;
    aWorkspaceSizeInBytes = aWorkspaceSizeInBytes;
    
    if(DX_IS_NULL_3PARAMS(aIterCookie_ptr,aHandlesBuff,aNumberOfHandlesToRead_ptr))
        return SST_RC_ERROR_NULL_POINTER;
    
    if(aHandlesLeft_ptr == DX_NULL)
    {
      return SST_RC_ERROR_NULL_POINTER;
    }

	/************************************************************************/
	/*  Lock access to SEP                                                  */
	/************************************************************************/
   errorRC = SEPDriver_Lock();
   if(DX_MNG_SEP_IS_DISABLE_ERR == errorRC)
   {
       errorRC = SST_RC_ERROR_SEP_DISABLED; 
       goto exit_function;
   }
   else if (DX_OK != errorRC)
   {
       errorRC = SST_RC_ERROR_SEP; 
       goto exit_function;
   }
	/************************************************************************/
    /* Prepare input buffer                                                 */
    /************************************************************************/
	/*allocate in SM*/
	errorRC = SEPDriver_AllocateDataPoolMemory((DxByte_t*)aHandlesBuff, 
									            ((*aNumberOfHandlesToRead_ptr)*sizeof(SSTHandle_t)), 
									            &handleBuffSMPhyAddress,
                                                &handleBuffSMVirtAddress);
	SST_HOST_DRIVER_ERROR_CHECK(errorRC,exit_ixlu_handles_get);
	
	/* Operation Code */
    paramInBuffer_ptr[0] = SST_SEP_OP_CODE_INDEX_LOOK_UP_HANDLES_GET;

    /* Input Parameters */
    paramInBuffer_ptr[1] = (DxUint32_t)aSessionId;
    paramInBuffer_ptr[2] = (DxUint32_t)aIterCookie_ptr->cookieHandle.prefixMsb;
    paramInBuffer_ptr[3] = (DxUint32_t)aIterCookie_ptr->cookieHandle.prefixLsb;     
    paramInBuffer_ptr[4] = (DxUint32_t)aIterCookie_ptr->cookieHandle.prefixSize;     
    paramInBuffer_ptr[5] = (DxUint32_t)aIterCookie_ptr->cookieHandle.lastPositionMsb;
    paramInBuffer_ptr[6] = (DxUint32_t)aIterCookie_ptr->cookieHandle.lastPositionLsb;
    paramInBuffer_ptr[7] = (DxUint32_t)aIterCookie_ptr->cookieHandle.initialUse;
    paramInBuffer_ptr[8] = (DxUint32_t)handleBuffSMPhyAddress;
    paramInBuffer_ptr[9] = (DxUint32_t)(*aNumberOfHandlesToRead_ptr);
	paramInBuffer_ptr[10] = (DxUint32_t)aHandlesLeft_ptr;

    /************************************************************************/
    /* Send an input buffer to SeP and wait for output parameters          */
    /************************************************************************/
    errorRC = SST_SendOneMsgGetResponse(paramInBuffer_ptr,
        /* Input buffer length */
        DX_11_WORDS_PARAMS * sizeof(DxUint32_t), 
        paramOutBuffer_ptr,
        /* Output buffer maximal length */
        DX_10_WORDS_PARAMS * sizeof(DxUint32_t));  
    if (DX_OK != errorRC)
        goto exit_ixlu_handles_get;

    /************************************************************************/
    /* Analyze return buffer                                                */
    /************************************************************************/
    /* Op code */
    if (paramOutBuffer_ptr[0] != SST_SEP_OP_CODE_INDEX_LOOK_UP_HANDLES_GET)
    {
        errorRC = SST_RC_ERROR_SEP;
        goto exit_ixlu_handles_get;
    }

    /* RC */    
	errorRC = paramOutBuffer_ptr[1];
	SST_HOST_RETURN_CODE_CHECK(errorRC,exit_ixlu_handles_get);

    /* Fill out output parameters */
	aIterCookie_ptr->cookieHandle.prefixMsb         = paramOutBuffer_ptr[2];
	aIterCookie_ptr->cookieHandle.prefixLsb         = paramOutBuffer_ptr[3];
	aIterCookie_ptr->cookieHandle.prefixSize        = paramOutBuffer_ptr[4];
	aIterCookie_ptr->cookieHandle.lastPositionMsb   = paramOutBuffer_ptr[5];
	aIterCookie_ptr->cookieHandle.lastPositionLsb   = paramOutBuffer_ptr[6];
	aIterCookie_ptr->cookieHandle.initialUse        = (DxBool_t)paramOutBuffer_ptr[7];
    *aNumberOfHandlesToRead_ptr						= paramOutBuffer_ptr[8];
	if (DX_NULL != aHandlesLeft_ptr)
	{
		*aHandlesLeft_ptr = paramOutBuffer_ptr[9];
	}
	/*copy from SM*/
	sepErrorRC = SEPDriver_ReadFromDataPoolMemory(handleBuffSMVirtAddress, 
                                            (DxByte_t*)aHandlesBuff, 
									        ((*aNumberOfHandlesToRead_ptr)*sizeof(SSTHandle_t)));
	SST_HOST_DRIVER_ERROR_CHECK(sepErrorRC,exit_ixlu_handles_get);

exit_ixlu_handles_get: 
	/************************************************************************/
	/* UnLock access to  SEP                                                  */
	/************************************************************************/
	SEPDriver_Unlock();

exit_function:
    
    return errorRC;
}

DxError_t  SST_IndexLookUpEnd (SSTIXCookie_t        *aIterCookie_ptr)
{
    DxUint32_t              paramInBuffer_ptr [DX_7_WORDS_PARAMS];
    DxUint32_t              paramOutBuffer_ptr[DX_2_WORDS_PARAMS];
    DxError_t               errorRC;

    if(DX_IS_NULL_PARAM(aIterCookie_ptr))
        return SST_RC_ERROR_NULL_POINTER;

	/************************************************************************/
	/*  Lock access to SEP                                                  */
	/************************************************************************/
   errorRC = SEPDriver_Lock();
   if(DX_MNG_SEP_IS_DISABLE_ERR == errorRC)
   {
       errorRC = SST_RC_ERROR_SEP_DISABLED; 
       goto exit_function;
   }
   else if (DX_OK != errorRC)
   {
       errorRC = SST_RC_ERROR_SEP; 
       goto exit_function;
   }
	/************************************************************************/
    /* Prepare input buffer                                                 */
    /************************************************************************/
    /* Operation Code */
    paramInBuffer_ptr[0] = SST_SEP_OP_CODE_INDEX_LOOK_UP_END;
    /*  Input Parameters */
    paramInBuffer_ptr[1] = (DxUint32_t)aIterCookie_ptr->cookieHandle.prefixMsb;
    paramInBuffer_ptr[2] = (DxUint32_t)aIterCookie_ptr->cookieHandle.prefixLsb;     
    paramInBuffer_ptr[3] = (DxUint32_t)aIterCookie_ptr->cookieHandle.prefixSize;     
    paramInBuffer_ptr[4] = (DxUint32_t)aIterCookie_ptr->cookieHandle.lastPositionMsb;
    paramInBuffer_ptr[5] = (DxUint32_t)aIterCookie_ptr->cookieHandle.lastPositionLsb;
    paramInBuffer_ptr[6] = (DxUint32_t)aIterCookie_ptr->cookieHandle.initialUse;

    /************************************************************************/
    /* Send an input buffer to SeP and wait for output parameters          */
    /************************************************************************/
    errorRC = SST_SendOneMsgGetResponse(paramInBuffer_ptr,
        /* Input buffer length */
        DX_7_WORDS_PARAMS * sizeof(DxUint32_t), 
        paramOutBuffer_ptr,
        /* Output buffer maximal length */
        DX_2_WORDS_PARAMS * sizeof(DxUint32_t));  
    if (DX_OK != errorRC)
        goto exit_ixlu_end;

    /************************************************************************/
    /* Analyze return buffer                                                */
    /************************************************************************/
    /* Op code */
    if (paramOutBuffer_ptr[0] != SST_SEP_OP_CODE_INDEX_LOOK_UP_END)
    {
        errorRC = SST_RC_ERROR_SEP;
        goto exit_ixlu_end;
    }

    /* RC */    
	errorRC = paramOutBuffer_ptr[1];
	SST_HOST_RETURN_CODE_CHECK(errorRC,exit_ixlu_end);

exit_ixlu_end: 
	/************************************************************************/
	/* UnLock access to  SEP                                                  */
	/************************************************************************/
	SEPDriver_Unlock();

exit_function:
    
    return errorRC;
}

/************************************************************************/
/*                    Type Iterator                                     */
/************************************************************************/
/*SST_TypeIteratorBegin*/
DxError_t SST_TypeIteratorBegin(SSTSessionId_t       aSessionId,
                                SSTDataType_t        aDataType,
                                SSTIteratorCookie_t  *aIteratorCookie_ptr,
                                DxByte_t			 *aWorkspace_ptr,
                                DxUint32_t			 aWorkspaceSizeInBytes)
{
    DxUint32_t              paramInBuffer_ptr [DX_3_WORDS_PARAMS];
    DxUint32_t              paramOutBuffer_ptr[DX_8_WORDS_PARAMS];
    DxError_t               errorRC;

    /* Eliminating warnings regarding useless variables */
    aWorkspace_ptr = aWorkspace_ptr;
    aWorkspaceSizeInBytes = aWorkspaceSizeInBytes;
    
    if(DX_IS_NULL_PARAM(aIteratorCookie_ptr))
        return SST_RC_ERROR_NULL_POINTER;

	/************************************************************************/
	/*  Lock access to SEP                                                  */
	/************************************************************************/
   errorRC = SEPDriver_Lock();
   if(DX_MNG_SEP_IS_DISABLE_ERR == errorRC)
   {
       errorRC = SST_RC_ERROR_SEP_DISABLED; 
       goto exit_function;
   }
   else if (DX_OK != errorRC)
   {
       errorRC = SST_RC_ERROR_SEP; 
       goto exit_function;
   }
	/************************************************************************/
    /* Prepare input buffer                                                 */
    /************************************************************************/
    /* Operation Code */
    paramInBuffer_ptr[0] = SST_SEP_OP_CODE_TYPE_ITERATOR_BEGIN;

    /*  Input Parameters */
    paramInBuffer_ptr[1] = (DxUint32_t)aSessionId;
    paramInBuffer_ptr[2] = (DxUint32_t)aDataType;

    /************************************************************************/
    /* Send an input buffer to SeP and wait for output parameters          */
    /************************************************************************/
    errorRC = SST_SendOneMsgGetResponse(paramInBuffer_ptr,
        /* Input buffer length */
        DX_3_WORDS_PARAMS * sizeof(DxUint32_t), 
        paramOutBuffer_ptr,
        /* Output buffer maximal length */
        DX_8_WORDS_PARAMS * sizeof(DxUint32_t));  
    if (DX_OK != errorRC)
        goto exit_iterator_begin;

    /************************************************************************/
    /* Analyze return buffer                                                */
    /************************************************************************/
    /* Op code */
    if (paramOutBuffer_ptr[0] != SST_SEP_OP_CODE_TYPE_ITERATOR_BEGIN)
    {
        errorRC = SST_RC_ERROR_SEP;
        goto exit_iterator_begin;
    }

    /* RC */    
	errorRC = paramOutBuffer_ptr[1];
	SST_HOST_RETURN_CODE_CHECK(errorRC,exit_iterator_begin);

	/* Fill out output parameters */
	aIteratorCookie_ptr->prefixMsb         = paramOutBuffer_ptr[2];
	aIteratorCookie_ptr->prefixLsb         = paramOutBuffer_ptr[3];
	aIteratorCookie_ptr->prefixSize        = paramOutBuffer_ptr[4];
	aIteratorCookie_ptr->lastPositionMsb   = paramOutBuffer_ptr[5];
	aIteratorCookie_ptr->lastPositionLsb   = paramOutBuffer_ptr[6];
	aIteratorCookie_ptr->initialUse        = (DxBool_t)paramOutBuffer_ptr[7];

exit_iterator_begin: 
	/************************************************************************/
	/* UnLock access to  SEP                                                  */
	/************************************************************************/
	SEPDriver_Unlock();

exit_function:
    
    return errorRC;
}



/*SST_TypeIteratorTerminate*/
DxError_t SST_TypeIteratorTerminate(SSTSessionId_t      aSessionId,
                                    SSTIteratorCookie_t *aIteratorCookie_ptr,
                                    DxByte_t			*aWorkspace_ptr,
                                    DxUint32_t			aWorkspaceSizeInBytes)
{
    DxUint32_t              paramInBuffer_ptr [DX_8_WORDS_PARAMS];
    DxUint32_t              paramOutBuffer_ptr[DX_2_WORDS_PARAMS];
    DxError_t               errorRC;

    /* Eliminating warnings regarding useless variables */
    aWorkspace_ptr = aWorkspace_ptr;
    aWorkspaceSizeInBytes = aWorkspaceSizeInBytes;
    
    if(DX_IS_NULL_PARAM(aIteratorCookie_ptr))
        return SST_RC_ERROR_NULL_POINTER;

	/************************************************************************/
	/*  Lock access to SEP                                                  */
	/************************************************************************/
   errorRC = SEPDriver_Lock();
   if(DX_MNG_SEP_IS_DISABLE_ERR == errorRC)
   {
       errorRC = SST_RC_ERROR_SEP_DISABLED; 
       goto exit_function;
   }
   else if (DX_OK != errorRC)
   {
       errorRC = SST_RC_ERROR_SEP; 
       goto exit_function;
   }
	/************************************************************************/
    /* Prepare input buffer                                                 */
    /************************************************************************/
    /* Operation Code */
    paramInBuffer_ptr[0] = SST_SEP_OP_CODE_TYPE_ITERATOR_TERMINATE;

    /*  Input Parameters */
    paramInBuffer_ptr[1] = (DxUint32_t)aSessionId;
    paramInBuffer_ptr[2] = (DxUint32_t)aIteratorCookie_ptr->prefixMsb;
    paramInBuffer_ptr[3] = (DxUint32_t)aIteratorCookie_ptr->prefixLsb;     
    paramInBuffer_ptr[4] = (DxUint32_t)aIteratorCookie_ptr->prefixSize;     
    paramInBuffer_ptr[5] = (DxUint32_t)aIteratorCookie_ptr->lastPositionMsb;
    paramInBuffer_ptr[6] = (DxUint32_t)aIteratorCookie_ptr->lastPositionLsb;
    paramInBuffer_ptr[7] = (DxUint32_t)aIteratorCookie_ptr->initialUse;

    /************************************************************************/
    /* Send an input buffer to SeP and wait for output parameters          */
    /************************************************************************/
    errorRC = SST_SendOneMsgGetResponse(paramInBuffer_ptr,
        /* Input buffer length */
        DX_8_WORDS_PARAMS * sizeof(DxUint32_t), 
        paramOutBuffer_ptr,
        /* Output buffer maximal length */
        DX_2_WORDS_PARAMS * sizeof(DxUint32_t));  
    if (DX_OK != errorRC)
        goto exit_iterator_terminate;

    /************************************************************************/
    /* Analyze return buffer                                                */
    /************************************************************************/
    /* Op code */
    if (paramOutBuffer_ptr[0] != SST_SEP_OP_CODE_TYPE_ITERATOR_TERMINATE)
    {
        errorRC = SST_RC_ERROR_SEP;
        goto exit_iterator_terminate;
    }

    /* RC */    
	errorRC = paramOutBuffer_ptr[1];
	SST_HOST_RETURN_CODE_CHECK(errorRC,exit_iterator_terminate);

exit_iterator_terminate: 
	/************************************************************************/
	/* UnLock access to  SEP                                                  */
	/************************************************************************/
	SEPDriver_Unlock();

exit_function:
    
    return errorRC;
}

/*SST_TypeIteratorHandleIncAndGet*/
DxError_t SST_TypeIteratorHandleIncAndGet(SSTSessionId_t        aSessionId,
                                          SSTIteratorCookie_t   *aIteratorCookie_ptr,
                                          SSTHandle_t           *aHandle_ptr,
                                          DxByte_t			    *aWorkspace_ptr,
                                          DxUint32_t			aWorkspaceSizeInBytes)
{
    DxUint32_t              paramInBuffer_ptr [DX_8_WORDS_PARAMS];
    DxUint32_t              paramOutBuffer_ptr[DX_10_WORDS_PARAMS];
    DxError_t               errorRC;

    /* Eliminating warnings regarding useless variables */
    aWorkspace_ptr = aWorkspace_ptr;
    aWorkspaceSizeInBytes = aWorkspaceSizeInBytes;
    
    if(DX_IS_NULL_2PARAMS(aIteratorCookie_ptr, aHandle_ptr))
        return SST_RC_ERROR_NULL_POINTER;

	/************************************************************************/
	/*  Lock access to SEP                                                  */
	/************************************************************************/
   errorRC = SEPDriver_Lock();
   if(DX_MNG_SEP_IS_DISABLE_ERR == errorRC)
   {
       errorRC = SST_RC_ERROR_SEP_DISABLED; 
       goto exit_function;
   }
   else if (DX_OK != errorRC)
   {
       errorRC = SST_RC_ERROR_SEP; 
       goto exit_function;
   }
	/************************************************************************/
    /* Prepare input buffer                                                 */
    /************************************************************************/
    /* Operation Code */
    paramInBuffer_ptr[0] = SST_SEP_OP_CODE_TYPE_ITERATOR_HANDLE_INC_AND_GET;

    /*  Input Parameters */
    paramInBuffer_ptr[1] = (DxUint32_t)aSessionId;
    paramInBuffer_ptr[2] = (DxUint32_t)aIteratorCookie_ptr->prefixMsb;
    paramInBuffer_ptr[3] = (DxUint32_t)aIteratorCookie_ptr->prefixLsb;     
    paramInBuffer_ptr[4] = (DxUint32_t)aIteratorCookie_ptr->prefixSize;     
    paramInBuffer_ptr[5] = (DxUint32_t)aIteratorCookie_ptr->lastPositionMsb;
    paramInBuffer_ptr[6] = (DxUint32_t)aIteratorCookie_ptr->lastPositionLsb;
    paramInBuffer_ptr[7] = (DxUint32_t)aIteratorCookie_ptr->initialUse;

    /************************************************************************/
    /* Send an input buffer to SeP and wait for output parameters          */
    /************************************************************************/
    errorRC = SST_SendOneMsgGetResponse(paramInBuffer_ptr,
        /* Input buffer length */
        DX_8_WORDS_PARAMS * sizeof(DxUint32_t), 
        paramOutBuffer_ptr,
        /* Output buffer maximal length */
        DX_10_WORDS_PARAMS * sizeof(DxUint32_t));  
    if (DX_OK != errorRC)
        goto exit_iterator_handle_inc_and_get;

    /************************************************************************/
    /* Analyze return buffer                                                */
    /************************************************************************/
    /* Op code */
    if (paramOutBuffer_ptr[0] != SST_SEP_OP_CODE_TYPE_ITERATOR_HANDLE_INC_AND_GET)
    {
        errorRC = SST_RC_ERROR_SEP;
        goto exit_iterator_handle_inc_and_get;
    }

    /* RC */    
	errorRC = paramOutBuffer_ptr[1];
	SST_HOST_RETURN_CODE_CHECK(errorRC,exit_iterator_handle_inc_and_get);

    /* Fill out output parameters */
	aIteratorCookie_ptr->prefixMsb       = paramOutBuffer_ptr[2];
	aIteratorCookie_ptr->prefixLsb       = paramOutBuffer_ptr[3];
	aIteratorCookie_ptr->prefixSize      = paramOutBuffer_ptr[4];
	aIteratorCookie_ptr->lastPositionMsb = paramOutBuffer_ptr[5];
	aIteratorCookie_ptr->lastPositionLsb = paramOutBuffer_ptr[6];
	aIteratorCookie_ptr->initialUse      = (DxBool_t)paramOutBuffer_ptr[7];
    aHandle_ptr->objDigest				 = paramOutBuffer_ptr[8];
    aHandle_ptr->objId					 = paramOutBuffer_ptr[9];

exit_iterator_handle_inc_and_get:  
	/************************************************************************/
	/* UnLock access to  SEP                                                  */
	/************************************************************************/
	SEPDriver_Unlock();

exit_function:
   
    return errorRC;
}

/*SST_TypeIteratorHandleDecAndGet*/
DxError_t SST_TypeIteratorHandleDecAndGet( SSTSessionId_t          aSessionId,
                                          SSTIteratorCookie_t    *aIteratorCookie_ptr,
                                          SSTHandle_t            *aHandle_ptr,
                                          DxByte_t			      *aWorkspace_ptr,
                                          DxUint32_t			   aWorkspaceSizeInBytes)
{
    DxUint32_t              paramInBuffer_ptr [DX_8_WORDS_PARAMS];
    DxUint32_t              paramOutBuffer_ptr[DX_10_WORDS_PARAMS];
    DxError_t               errorRC;

    /* Eliminating warnings regarding useless variables */
    aWorkspace_ptr = aWorkspace_ptr;
    aWorkspaceSizeInBytes = aWorkspaceSizeInBytes;
    
    if(DX_IS_NULL_2PARAMS(aIteratorCookie_ptr, aHandle_ptr))
        return SST_RC_ERROR_NULL_POINTER;

	/************************************************************************/
	/*  Lock access to SEP                                                  */
	/************************************************************************/
   errorRC = SEPDriver_Lock();
   if(DX_MNG_SEP_IS_DISABLE_ERR == errorRC)
   {
       errorRC = SST_RC_ERROR_SEP_DISABLED; 
       goto exit_function;
   }
   else if (DX_OK != errorRC)
   {
       errorRC = SST_RC_ERROR_SEP; 
       goto exit_function;
   }
	/************************************************************************/
    /* Prepare input buffer                                                 */
    /************************************************************************/
    /* Operation Code */
    paramInBuffer_ptr[0] = SST_SEP_OP_CODE_TYPE_ITERATOR_HANDLE_DEC_AND_GET;

    /*  Input Parameters */
    paramInBuffer_ptr[1] = (DxUint32_t)aSessionId;
    paramInBuffer_ptr[2] = (DxUint32_t)aIteratorCookie_ptr->prefixMsb;
    paramInBuffer_ptr[3] = (DxUint32_t)aIteratorCookie_ptr->prefixLsb;     
    paramInBuffer_ptr[4] = (DxUint32_t)aIteratorCookie_ptr->prefixSize;     
    paramInBuffer_ptr[5] = (DxUint32_t)aIteratorCookie_ptr->lastPositionMsb;
    paramInBuffer_ptr[6] = (DxUint32_t)aIteratorCookie_ptr->lastPositionLsb;
    paramInBuffer_ptr[7] = (DxUint32_t)aIteratorCookie_ptr->initialUse;

    /************************************************************************/
    /* Send an input buffer to SeP and wait for output parameters          */
    /************************************************************************/
    errorRC = SST_SendOneMsgGetResponse(paramInBuffer_ptr,
        /* Input buffer length */
        DX_8_WORDS_PARAMS * sizeof(DxUint32_t), 
        paramOutBuffer_ptr,
        /* Output buffer maximal length */
        DX_10_WORDS_PARAMS * sizeof(DxUint32_t));  
    if (DX_OK != errorRC)
        goto exit_iterator_handle_dec_and_get;

    /************************************************************************/
    /* Analyze return buffer                                                */
    /************************************************************************/
    /* Op code */
    if (paramOutBuffer_ptr[0] != SST_SEP_OP_CODE_TYPE_ITERATOR_HANDLE_DEC_AND_GET)
    {
        errorRC = SST_RC_ERROR_SEP;
        goto exit_iterator_handle_dec_and_get;
    }

    /* RC */    
	errorRC = paramOutBuffer_ptr[1];
	SST_HOST_RETURN_CODE_CHECK(errorRC,exit_iterator_handle_dec_and_get);

    /* Fill out output parameters */
	aIteratorCookie_ptr->prefixMsb       = paramOutBuffer_ptr[2];
	aIteratorCookie_ptr->prefixLsb       = paramOutBuffer_ptr[3];
	aIteratorCookie_ptr->prefixSize      = paramOutBuffer_ptr[4];
	aIteratorCookie_ptr->lastPositionMsb = paramOutBuffer_ptr[5];
	aIteratorCookie_ptr->lastPositionLsb = paramOutBuffer_ptr[6];
	aIteratorCookie_ptr->initialUse      = (DxBool_t)paramOutBuffer_ptr[7];
    aHandle_ptr->objDigest				 = paramOutBuffer_ptr[8];
    aHandle_ptr->objId					 = paramOutBuffer_ptr[9];

exit_iterator_handle_dec_and_get: 
	/************************************************************************/
	/* UnLock access to  SEP                                                  */
	/************************************************************************/
	SEPDriver_Unlock();

exit_function:
    
    return errorRC;
}



/*SST_TypeIteratorCurrentGet*/
DxError_t SST_TypeIteratorCurrentGet(SSTSessionId_t       aSessionId,
                                     SSTIteratorCookie_t  *aIteratorCookie_ptr,
                                     SSTHandle_t          *aHandle_ptr,
                                     DxByte_t			  *aWorkspace_ptr,
                                     DxUint32_t			  aWorkspaceSizeInBytes)
{
    DxUint32_t              paramInBuffer_ptr [DX_8_WORDS_PARAMS];
    DxUint32_t              paramOutBuffer_ptr[DX_10_WORDS_PARAMS];
    DxError_t               errorRC;

    /* Eliminating warnings regarding useless variables */
    aWorkspace_ptr = aWorkspace_ptr;
    aWorkspaceSizeInBytes = aWorkspaceSizeInBytes;

    if(DX_IS_NULL_2PARAMS(aIteratorCookie_ptr, aHandle_ptr))
        return SST_RC_ERROR_NULL_POINTER;

	/************************************************************************/
	/*  Lock access to SEP                                                  */
	/************************************************************************/
   errorRC = SEPDriver_Lock();
   if(DX_MNG_SEP_IS_DISABLE_ERR == errorRC)
   {
       errorRC = SST_RC_ERROR_SEP_DISABLED; 
       goto exit_function;
   }
   else if (DX_OK != errorRC)
   {
       errorRC = SST_RC_ERROR_SEP; 
       goto exit_function;
   }
	/************************************************************************/
    /* Prepare input buffer                                                 */
    /************************************************************************/
    /* Operation Code */
    paramInBuffer_ptr[0] = SST_SEP_OP_CODE_TYPE_ITERATOR_CURRENT_GET;

    /*  Input Parameters */
    paramInBuffer_ptr[1] = (DxUint32_t)aSessionId;
    paramInBuffer_ptr[2] = (DxUint32_t)aIteratorCookie_ptr->prefixMsb;
    paramInBuffer_ptr[3] = (DxUint32_t)aIteratorCookie_ptr->prefixLsb;     
    paramInBuffer_ptr[4] = (DxUint32_t)aIteratorCookie_ptr->prefixSize;     
    paramInBuffer_ptr[5] = (DxUint32_t)aIteratorCookie_ptr->lastPositionMsb;
    paramInBuffer_ptr[6] = (DxUint32_t)aIteratorCookie_ptr->lastPositionLsb;
    paramInBuffer_ptr[7] = (DxUint32_t)aIteratorCookie_ptr->initialUse;

    /************************************************************************/
    /* Send an input buffer to SeP and wait for output parameters          */
    /************************************************************************/
    errorRC = SST_SendOneMsgGetResponse(paramInBuffer_ptr,
        /* Input buffer length */
        DX_8_WORDS_PARAMS * sizeof(DxUint32_t), 
        paramOutBuffer_ptr,
        /* Output buffer maximal length */
        DX_10_WORDS_PARAMS * sizeof(DxUint32_t));  
    if (DX_OK != errorRC)
        goto exit_iterator_curr_get;

    /************************************************************************/
    /* Analyze return buffer                                                */
    /************************************************************************/
    /* Op code */
    if (paramOutBuffer_ptr[0] != SST_SEP_OP_CODE_TYPE_ITERATOR_CURRENT_GET)
    {
        errorRC = SST_RC_ERROR_SEP;
        goto exit_iterator_curr_get;
    }

    /* RC */    
	errorRC = paramOutBuffer_ptr[1];
	SST_HOST_RETURN_CODE_CHECK(errorRC,exit_iterator_curr_get);

    /* Fill out output parameters */
	aIteratorCookie_ptr->prefixMsb       = paramOutBuffer_ptr[2];
	aIteratorCookie_ptr->prefixLsb       = paramOutBuffer_ptr[3];
	aIteratorCookie_ptr->prefixSize      = paramOutBuffer_ptr[4];
	aIteratorCookie_ptr->lastPositionMsb = paramOutBuffer_ptr[5];
	aIteratorCookie_ptr->lastPositionLsb = paramOutBuffer_ptr[6];
	aIteratorCookie_ptr->initialUse      = (DxBool_t)paramOutBuffer_ptr[7];
    aHandle_ptr->objDigest				 = paramOutBuffer_ptr[8];
    aHandle_ptr->objId					 = paramOutBuffer_ptr[9];

exit_iterator_curr_get:  
	/************************************************************************/
	/* UnLock access to  SEP                                                  */
	/************************************************************************/
	SEPDriver_Unlock();

exit_function:
   
    return errorRC;
}



/*SST_TypeIteratorHandlesGet*/
DxError_t SST_TypeIteratorHandlesGet(SSTSessionId_t      aSessionId,
                                     SSTIteratorCookie_t *aIteratorCookie_ptr,
                                     DxUint32_t          *aHandlesRead_ptr,
                                     SSTHandle_t         *aHandleBuff_ptr,
                                     DxUint32_t          *aHandlesLeft_ptr,
                                     DxByte_t			 *aWorkspace_ptr,
                                     DxUint32_t		     aWorkspaceSizeInBytes)
{
    DxUint32_t              paramInBuffer_ptr [DX_11_WORDS_PARAMS];
    DxUint32_t              paramOutBuffer_ptr[DX_10_WORDS_PARAMS];
    DxError_t               errorRC;
    DxError_t               sepErrorRC;
    DxUint32_t				handleBuffSMPhyAddress;
    DxUint32_t				handleBuffSMVirtAddress;

    /* Eliminating warnings regarding useless variables */
    aWorkspace_ptr = aWorkspace_ptr;
    aWorkspaceSizeInBytes = aWorkspaceSizeInBytes;

    if(DX_IS_NULL_3PARAMS(aIteratorCookie_ptr, aHandlesRead_ptr, aHandleBuff_ptr))
        return SST_RC_ERROR_NULL_POINTER;

	/************************************************************************/
	/*  Lock access to SEP                                                  */
	/************************************************************************/
   errorRC = SEPDriver_Lock();
   if(DX_MNG_SEP_IS_DISABLE_ERR == errorRC)
   {
       errorRC = SST_RC_ERROR_SEP_DISABLED; 
       goto exit_function;
   }
   else if (DX_OK != errorRC)
   {
       errorRC = SST_RC_ERROR_SEP; 
       goto exit_function;
   }
	/************************************************************************/
    /* Prepare input buffer                                                 */
    /************************************************************************/
	/*allocate in SM*/
	errorRC = SEPDriver_AllocateDataPoolMemory((DxByte_t*)aHandleBuff_ptr, 
									  ((*aHandlesRead_ptr)*sizeof(SSTHandle_t)), 
									  &handleBuffSMPhyAddress,
                                      &handleBuffSMVirtAddress);
	SST_HOST_DRIVER_ERROR_CHECK(errorRC,exit_iterator_handles_get);

	/* Operation Code */
    paramInBuffer_ptr[0] =  SST_SEP_OP_CODE_TYPE_ITERATOR_HANDLES_GET;

    /*  Input Parameters */
    paramInBuffer_ptr[1] = (DxUint32_t)aSessionId;
    paramInBuffer_ptr[2] = (DxUint32_t)aIteratorCookie_ptr->prefixMsb;
    paramInBuffer_ptr[3] = (DxUint32_t)aIteratorCookie_ptr->prefixLsb;     
    paramInBuffer_ptr[4] = (DxUint32_t)aIteratorCookie_ptr->prefixSize;     
    paramInBuffer_ptr[5] = (DxUint32_t)aIteratorCookie_ptr->lastPositionMsb;
    paramInBuffer_ptr[6] = (DxUint32_t)aIteratorCookie_ptr->lastPositionLsb;
    paramInBuffer_ptr[7] = (DxUint32_t)aIteratorCookie_ptr->initialUse;
    paramInBuffer_ptr[8] = (DxUint32_t)(*aHandlesRead_ptr);
    paramInBuffer_ptr[9] = (DxUint32_t)handleBuffSMPhyAddress;
	paramInBuffer_ptr[10] = (DxUint32_t)aHandlesLeft_ptr;

    /************************************************************************/
    /* Send an input buffer to SeP and wait for output parameters          */
    /************************************************************************/
    errorRC = SST_SendOneMsgGetResponse(paramInBuffer_ptr,
        /* Input buffer length */
        DX_10_WORDS_PARAMS * sizeof(DxUint32_t), 
        paramOutBuffer_ptr,
        /* Output buffer maximal length */
        DX_10_WORDS_PARAMS * sizeof(DxUint32_t));  
    if (DX_OK != errorRC)
        goto exit_iterator_handles_get;

    /************************************************************************/
    /* Analyze return buffer                                                */
    /************************************************************************/
    /* Op code */
    if (paramOutBuffer_ptr[0] != SST_SEP_OP_CODE_TYPE_ITERATOR_HANDLES_GET)
    {
        errorRC = SST_RC_ERROR_SEP;
        goto exit_iterator_handles_get;
    }

    /* RC */    
	errorRC = paramOutBuffer_ptr[1];
	SST_HOST_RETURN_CODE_CHECK(errorRC,exit_iterator_handles_get);

    /* Fill out output parameters */
	aIteratorCookie_ptr->prefixMsb       = paramOutBuffer_ptr[2];
	aIteratorCookie_ptr->prefixLsb       = paramOutBuffer_ptr[3];
	aIteratorCookie_ptr->prefixSize      = paramOutBuffer_ptr[4];
	aIteratorCookie_ptr->lastPositionMsb = paramOutBuffer_ptr[5];
	aIteratorCookie_ptr->lastPositionLsb = paramOutBuffer_ptr[6];
	aIteratorCookie_ptr->initialUse      = (DxBool_t)paramOutBuffer_ptr[7];
    *aHandlesRead_ptr					 = paramOutBuffer_ptr[8];
	if (DX_NULL != aHandlesLeft_ptr)
	{
		*aHandlesLeft_ptr					 = paramOutBuffer_ptr[9];
	}
	/*copy from SM*/
	sepErrorRC = SEPDriver_ReadFromDataPoolMemory(handleBuffSMVirtAddress,
                                             (DxByte_t*)aHandleBuff_ptr, 
									          ((*aHandlesRead_ptr)*sizeof(SSTHandle_t)));
	SST_HOST_DRIVER_ERROR_CHECK(sepErrorRC,exit_iterator_handles_get);


exit_iterator_handles_get: 
	/************************************************************************/
	/* UnLock access to  SEP                                                  */
	/************************************************************************/
	SEPDriver_Unlock();

exit_function:
    
    return errorRC;
}


